#ifndef _SS_DEBUG_H
#define _SS_DEBUG_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//#define _EXT_ASSERT_DEBUG

#ifdef _EXT_ASSERT_DEBUG
#define Assert(sExpression, sMsg) \
	if(sExpression)\
	{ \
		char sAssert[2048]; \
		sprintf(sAssert, "A fatal error has occured and the Application must be ended.\r\n" \
			"\tPlease take note of the following error message and conditions.\t\n\r\n" \
			"File: \"%s\"\r\nApp Date/Time: %s (%s)\r\nExpression: \"%s\"\r\nLine: %d\r\n\r\n%s", \
			__FILE__, __DATE__, __TIME__, #sExpression, __LINE__, sMsg); \
		MessageBox(NULL, sAssert, "Fatal Application Error!", MB_ICONSTOP | MB_SYSTEMMODAL); \

		sprintf(sAssert, "Assert-> Error in '%s'\r\nDate: %s - %s\r\nLine: %d\r\nMessage: %s",
			__FILE__, __DATE__, __TIME__, __LINE__, sMsg);
		giErrorCount++;
		WriteSysLog(sAssert);
	}
#else
#define Assert(sExpression, sMsg)
#endif

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
